# Prof-TC
# Decembre 2020
# Loi d'Ohm
# Tracé de U=f(I) pour une résistance

#Affichage du nom du programme
print("_________________________________________________________")
print("loi d'Ohm")
print("_________________________________________________________")

#Importation des bibliothèques
import matplotlib.pyplot as plt
import numpy as np

#Vleurs expérimentales à modifier selon l'expérience (U en volt et I en milliampère)
print("**********************************************")
I=[0, 6.8, 8.2, 9.5, 10.9, 12.3, 13.6, 15.0, 16.4, 17.7, 19.1, 20.5, 21.8, 23.2, 24.5, 25.9, 27.3]
U=[0, 1.5, 1.8, 2.1, 2.4, 2.7, 3, 3.3, 3.6, 3.9, 4.2, 4.5, 4.8, 5.1, 5.4, 5.7, 6]
print("**********************************************")

#Affichage des valeurs expérimentales et du nombre de points
print("valeurs de I:, ",I)
print("valeurs de U: ",U)
print("Il y a ",len(I)," couples de points")
print("**********************************************")

#Initialisation des variables
Imoy=0.0
Umoy=0.0
N=0.0
D=0.0
a=0.0
b=0.0
Imin=I[0]
Umin=U[0]
Imax=I[len(I)-1]
Umax=U[len(U)-1]

# Initialisation de la figure
fig, ax = plt.subplots()

#Calcul des coefficients de la droite représentant U=f(I)
for i in range (len(I)):
    Imoy=Imoy+I[i]
    Umoy=Umoy+U[i]

Imoy=Imoy/(len(I))
Umoy=Umoy/(len(U))

for i in range (len(I)):
    N=N+(I[i]-Imoy)*(U[i]-Umoy)
    D=D+(I[i]-Imoy)*(I[i]-Imoy)

a=N/D #Coefficient directeur de la droite
R=a #Valeur de la résistance
b=Umoy-a*Imoy #Ordonnée à l'origine de la droite

#Mise en écriture avec 5 décimales pour l'affichage de l'équation
Rs=round(R,5)
bs=round (b,5)

#Mise en écriture pour l'affichage de la résistance
Ro=int(R*1000)


#Tracé des axes, labels et titre du graphique
plt.axis([0, Imax, 0, Umax])
plt.xlabel('I (mA)',color='green', fontsize=20)
plt.ylabel('U (V)',color='green', fontsize=20)
plt.title("Caractéristique d'un conducteur Ohmique - Loi d'Ohm", color='red', fontsize=10)
plt.grid()

#Tracé des valeurs expérimentales
plt.scatter(I,U,marker='o',color='r',linewidth = 4)

#Tracé de la droite
x=np.linspace(0,Imax+1,200)
y=R*x+b
plt.plot(x,y,linewidth = 2)

#Ecriture de l'équation de la droite
plt.text((Imax)/2, Umax-Umax*0.1, "U = "+str(Rs)+" x I + "+str(bs), color='green', fontsize=10,horizontalalignment = 'center')

#Ecriture de la valeur de la Résistance
plt.text((Imax)/2, Umax-Umax*0.2, "U = "+str(Ro)+" Ohm", color='green', fontsize=10,horizontalalignment = 'center')

#Affichage du graphique
plt.show()

# Sauvegarde de la figure dans le dossier où se trouve le programme
fig.savefig("Loi d'Ohm")

print("********************************************************")
print("L'équation de la droite est: U = ",Rs," x I + ",bs)
print("********************************************************")

#Fin du programme